//! # DBus interface proxies for: `org.mpris.MediaPlayer2`, `org.mpris.MediaPlayer2.Player`
//!
//! This code was generated by `zbus-xmlgen` `1.0.0` from DBus introspection data.
//! Source: `11`.
//!
//! You may prefer to adapt it, instead of using it verbatim.
//!
//! More information can be found in the
//! [Writing a client proxy](https://zeenix.pages.freedesktop.org/zbus/client.html)
//! section of the zbus documentation.
//!
//! This DBus object implements
//! [standard DBus interfaces](https://dbus.freedesktop.org/doc/dbus-specification.html),
//! (`org.freedesktop.DBus.*`) for which the following zbus proxies can be used:
//!
//! * [`zbus::fdo::PropertiesProxy`]
//! * [`zbus::fdo::IntrospectableProxy`]
//! * [`zbus::fdo::PeerProxy`]
//!
//! …consequently `zbus-xmlgen` did not generate code for the above interfaces.

use std::collections::HashMap;
use zbus::dbus_proxy;
use zbus::zvariant::{self, ObjectPath, OwnedValue, Type, Value};

#[derive(Debug, Clone)]
pub struct PlayerMetadata {
    pub title: Option<String>,
    pub artist: Option<String>,
    pub url: Option<String>,
}

impl Type for PlayerMetadata {
    fn signature() -> zvariant::Signature<'static> {
        <HashMap<String, OwnedValue> as Type>::signature()
    }
}

impl TryFrom<OwnedValue> for PlayerMetadata {
    type Error = <HashMap<String, OwnedValue> as TryFrom<OwnedValue>>::Error;

    fn try_from(value: OwnedValue) -> Result<Self, Self::Error> {
        let map = HashMap::<String, OwnedValue>::try_from(value)?;

        let val_to_string = |val: &Value| {
            val.downcast_ref::<str>()
                .and_then(|val| (!val.is_empty()).then(|| val.to_string()))
        };

        let title = map.get("xesam:title").and_then(|val| val_to_string(val));

        let artists = map
            .get("xesam:artist")
            .and_then(|val| val.downcast_ref::<zvariant::Array>())
            .map(|val| val.get());
        let artist = artists.and_then(|val| val.get(0)).and_then(val_to_string);

        let url = map.get("xesam:url").and_then(|val| val_to_string(val));

        Ok(Self { title, artist, url })
    }
}

#[dbus_proxy(
    interface = "org.mpris.MediaPlayer2",
    default_path = "/org/mpris/MediaPlayer2"
)]
trait MediaPlayer2 {
    /// Quit method
    fn quit(&self) -> zbus::Result<()>;

    /// Raise method
    fn raise(&self) -> zbus::Result<()>;

    /// CanQuit property
    #[dbus_proxy(property)]
    fn can_quit(&self) -> zbus::Result<bool>;

    /// CanRaise property
    #[dbus_proxy(property)]
    fn can_raise(&self) -> zbus::Result<bool>;

    /// DesktopEntry property
    #[dbus_proxy(property)]
    fn desktop_entry(&self) -> zbus::Result<String>;

    /// HasTrackList property
    #[dbus_proxy(property)]
    fn has_track_list(&self) -> zbus::Result<bool>;

    /// Identity property
    #[dbus_proxy(property)]
    fn identity(&self) -> zbus::Result<String>;

    /// SupportedMimeTypes property
    #[dbus_proxy(property)]
    fn supported_mime_types(&self) -> zbus::Result<Vec<String>>;

    /// SupportedUriSchemes property
    #[dbus_proxy(property)]
    fn supported_uri_schemes(&self) -> zbus::Result<Vec<String>>;
}

#[dbus_proxy(
    interface = "org.mpris.MediaPlayer2.Player",
    default_path = "/org/mpris/MediaPlayer2"
)]
trait Player {
    /// Next method
    fn next(&self) -> zbus::Result<()>;

    /// OpenUri method
    fn open_uri(&self, uri: &str) -> zbus::Result<()>;

    /// Pause method
    fn pause(&self) -> zbus::Result<()>;

    /// Play method
    fn play(&self) -> zbus::Result<()>;

    /// PlayPause method
    fn play_pause(&self) -> zbus::Result<()>;

    /// Previous method
    fn previous(&self) -> zbus::Result<()>;

    /// Seek method
    fn seek(&self, offset: i64) -> zbus::Result<()>;

    /// SetPosition method
    fn set_position(&self, track_id: &ObjectPath<'_>, position: i64) -> zbus::Result<()>;

    /// Stop method
    fn stop(&self) -> zbus::Result<()>;

    /// Seeked signal
    #[dbus_proxy(signal)]
    fn seeked(&self, position: i64) -> zbus::Result<()>;

    /// CanControl property
    #[dbus_proxy(property)]
    fn can_control(&self) -> zbus::Result<bool>;

    /// CanGoNext property
    #[dbus_proxy(property)]
    fn can_go_next(&self) -> zbus::Result<bool>;

    /// CanGoPrevious property
    #[dbus_proxy(property)]
    fn can_go_previous(&self) -> zbus::Result<bool>;

    /// CanPause property
    #[dbus_proxy(property)]
    fn can_pause(&self) -> zbus::Result<bool>;

    /// CanPlay property
    #[dbus_proxy(property)]
    fn can_play(&self) -> zbus::Result<bool>;

    /// CanSeek property
    #[dbus_proxy(property)]
    fn can_seek(&self) -> zbus::Result<bool>;

    /// MaximumRate property
    #[dbus_proxy(property)]
    fn maximum_rate(&self) -> zbus::Result<f64>;

    /// Metadata property
    #[dbus_proxy(property)]
    fn metadata(&self) -> zbus::Result<PlayerMetadata>;

    /// MinimumRate property
    #[dbus_proxy(property)]
    fn minimum_rate(&self) -> zbus::Result<f64>;

    /// PlaybackStatus property
    #[dbus_proxy(property)]
    fn playback_status(&self) -> zbus::Result<String>;

    /// Position property
    #[dbus_proxy(property)]
    fn position(&self) -> zbus::Result<i64>;

    /// Rate property
    #[dbus_proxy(property)]
    fn rate(&self) -> zbus::Result<f64>;
    #[dbus_proxy(property)]
    fn set_rate(&self, value: f64) -> zbus::Result<()>;

    /// Volume property
    #[dbus_proxy(property)]
    fn volume(&self) -> zbus::Result<f64>;
    #[dbus_proxy(property)]
    fn set_volume(&self, value: f64) -> zbus::Result<()>;
}
