/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "config_manager.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.DBus.Peer
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgFreedesktopDBusPeer
 * @title: OrgFreedesktopDBusPeer
 * @short_description: Generated C code for the org.freedesktop.DBus.Peer D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-DBus-Peer.top_of_page">org.freedesktop.DBus.Peer</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.DBus.Peer ---- */

static const _ExtendedGDBusMethodInfo _org_freedesktop_dbus_peer_method_info_ping =
{
  {
    -1,
    (gchar *) "Ping",
    NULL,
    NULL,
    NULL
  },
  "handle-ping",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_peer_method_info_get_machine_id_OUT_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_dbus_peer_method_info_get_machine_id_OUT_ARG_pointers[] =
{
  &_org_freedesktop_dbus_peer_method_info_get_machine_id_OUT_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_dbus_peer_method_info_get_machine_id =
{
  {
    -1,
    (gchar *) "GetMachineId",
    NULL,
    (GDBusArgInfo **) &_org_freedesktop_dbus_peer_method_info_get_machine_id_OUT_ARG_pointers,
    NULL
  },
  "handle-get-machine-id",
  FALSE
};

static const GDBusMethodInfo * const _org_freedesktop_dbus_peer_method_info_pointers[] =
{
  &_org_freedesktop_dbus_peer_method_info_ping.parent_struct,
  &_org_freedesktop_dbus_peer_method_info_get_machine_id.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_freedesktop_dbus_peer_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.DBus.Peer",
    (GDBusMethodInfo **) &_org_freedesktop_dbus_peer_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "org-freedesktop-dbus-peer",
};


/**
 * org_freedesktop_dbus_peer_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-DBus-Peer.top_of_page">org.freedesktop.DBus.Peer</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_freedesktop_dbus_peer_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_freedesktop_dbus_peer_interface_info.parent_struct;
}

/**
 * org_freedesktop_dbus_peer_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgFreedesktopDBusPeer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_freedesktop_dbus_peer_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * OrgFreedesktopDBusPeer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Peer.top_of_page">org.freedesktop.DBus.Peer</link>.
 */

/**
 * OrgFreedesktopDBusPeerIface:
 * @parent_iface: The parent interface.
 * @handle_get_machine_id: Handler for the #OrgFreedesktopDBusPeer::handle-get-machine-id signal.
 * @handle_ping: Handler for the #OrgFreedesktopDBusPeer::handle-ping signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Peer.top_of_page">org.freedesktop.DBus.Peer</link>.
 */

typedef OrgFreedesktopDBusPeerIface OrgFreedesktopDBusPeerInterface;
G_DEFINE_INTERFACE (OrgFreedesktopDBusPeer, org_freedesktop_dbus_peer, G_TYPE_OBJECT)

static void
org_freedesktop_dbus_peer_default_init (OrgFreedesktopDBusPeerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgFreedesktopDBusPeer::handle-ping:
   * @object: A #OrgFreedesktopDBusPeer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DBus-Peer.Ping">Ping()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_dbus_peer_complete_ping() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-ping",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopDBusPeerIface, handle_ping),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgFreedesktopDBusPeer::handle-get-machine-id:
   * @object: A #OrgFreedesktopDBusPeer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DBus-Peer.GetMachineId">GetMachineId()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_dbus_peer_complete_get_machine_id() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-machine-id",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopDBusPeerIface, handle_get_machine_id),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * org_freedesktop_dbus_peer_call_ping:
 * @proxy: A #OrgFreedesktopDBusPeerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Peer.Ping">Ping()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_peer_call_ping_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_peer_call_ping_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_dbus_peer_call_ping (
    OrgFreedesktopDBusPeer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Ping",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_dbus_peer_call_ping_finish:
 * @proxy: A #OrgFreedesktopDBusPeerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_peer_call_ping().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_dbus_peer_call_ping().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_peer_call_ping_finish (
    OrgFreedesktopDBusPeer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_peer_call_ping_sync:
 * @proxy: A #OrgFreedesktopDBusPeerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Peer.Ping">Ping()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_peer_call_ping() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_peer_call_ping_sync (
    OrgFreedesktopDBusPeer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Ping",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_peer_call_get_machine_id:
 * @proxy: A #OrgFreedesktopDBusPeerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Peer.GetMachineId">GetMachineId()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_peer_call_get_machine_id_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_peer_call_get_machine_id_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_dbus_peer_call_get_machine_id (
    OrgFreedesktopDBusPeer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetMachineId",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_dbus_peer_call_get_machine_id_finish:
 * @proxy: A #OrgFreedesktopDBusPeerProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_peer_call_get_machine_id().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_dbus_peer_call_get_machine_id().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_peer_call_get_machine_id_finish (
    OrgFreedesktopDBusPeer *proxy,
    gchar **out_unnamed_arg0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_peer_call_get_machine_id_sync:
 * @proxy: A #OrgFreedesktopDBusPeerProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Peer.GetMachineId">GetMachineId()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_peer_call_get_machine_id() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_peer_call_get_machine_id_sync (
    OrgFreedesktopDBusPeer *proxy,
    gchar **out_unnamed_arg0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetMachineId",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_peer_complete_ping:
 * @object: A #OrgFreedesktopDBusPeer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DBus-Peer.Ping">Ping()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_dbus_peer_complete_ping (
    OrgFreedesktopDBusPeer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_dbus_peer_complete_get_machine_id:
 * @object: A #OrgFreedesktopDBusPeer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DBus-Peer.GetMachineId">GetMachineId()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_dbus_peer_complete_get_machine_id (
    OrgFreedesktopDBusPeer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *unnamed_arg0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   unnamed_arg0));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopDBusPeerProxy:
 *
 * The #OrgFreedesktopDBusPeerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopDBusPeerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopDBusPeerProxy.
 */

struct _OrgFreedesktopDBusPeerProxyPrivate
{
  GData *qdata;
};

static void org_freedesktop_dbus_peer_proxy_iface_init (OrgFreedesktopDBusPeerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusPeerProxy, org_freedesktop_dbus_peer_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgFreedesktopDBusPeerProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_PEER, org_freedesktop_dbus_peer_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusPeerProxy, org_freedesktop_dbus_peer_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_PEER, org_freedesktop_dbus_peer_proxy_iface_init))

#endif
static void
org_freedesktop_dbus_peer_proxy_finalize (GObject *object)
{
  OrgFreedesktopDBusPeerProxy *proxy = ORG_FREEDESKTOP_DBUS_PEER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_freedesktop_dbus_peer_proxy_parent_class)->finalize (object);
}

static void
org_freedesktop_dbus_peer_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_freedesktop_dbus_peer_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_freedesktop_dbus_peer_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_peer_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_FREEDESKTOP_DBUS_PEER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_DBUS_PEER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_freedesktop_dbus_peer_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgFreedesktopDBusPeerProxy *proxy = ORG_FREEDESKTOP_DBUS_PEER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_peer_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_peer_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_freedesktop_dbus_peer_proxy_init (OrgFreedesktopDBusPeerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_freedesktop_dbus_peer_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_FREEDESKTOP_DBUS_PEER_PROXY, OrgFreedesktopDBusPeerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_freedesktop_dbus_peer_interface_info ());
}

static void
org_freedesktop_dbus_peer_proxy_class_init (OrgFreedesktopDBusPeerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_freedesktop_dbus_peer_proxy_finalize;
  gobject_class->get_property = org_freedesktop_dbus_peer_proxy_get_property;
  gobject_class->set_property = org_freedesktop_dbus_peer_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_freedesktop_dbus_peer_proxy_g_signal;
  proxy_class->g_properties_changed = org_freedesktop_dbus_peer_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopDBusPeerProxyPrivate));
#endif
}

static void
org_freedesktop_dbus_peer_proxy_iface_init (OrgFreedesktopDBusPeerIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_freedesktop_dbus_peer_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Peer.top_of_page">org.freedesktop.DBus.Peer</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_peer_proxy_new_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_peer_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_dbus_peer_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_DBUS_PEER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Peer", NULL);
}

/**
 * org_freedesktop_dbus_peer_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_peer_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_dbus_peer_proxy_new().
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPeerProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusPeer *
org_freedesktop_dbus_peer_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_PEER (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_dbus_peer_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Peer.top_of_page">org.freedesktop.DBus.Peer</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_peer_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPeerProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusPeer *
org_freedesktop_dbus_peer_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_DBUS_PEER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Peer", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_PEER (ret);
  else
    return NULL;
}


/**
 * org_freedesktop_dbus_peer_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_freedesktop_dbus_peer_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_peer_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_peer_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_dbus_peer_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_DBUS_PEER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Peer", NULL);
}

/**
 * org_freedesktop_dbus_peer_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_peer_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_dbus_peer_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPeerProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusPeer *
org_freedesktop_dbus_peer_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_PEER (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_dbus_peer_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_freedesktop_dbus_peer_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_peer_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPeerProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusPeer *
org_freedesktop_dbus_peer_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_DBUS_PEER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Peer", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_PEER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopDBusPeerSkeleton:
 *
 * The #OrgFreedesktopDBusPeerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopDBusPeerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopDBusPeerSkeleton.
 */

struct _OrgFreedesktopDBusPeerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_freedesktop_dbus_peer_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgFreedesktopDBusPeerSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PEER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_FREEDESKTOP_DBUS_PEER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_DBUS_PEER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_freedesktop_dbus_peer_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopDBusPeerSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PEER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_peer_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_freedesktop_dbus_peer_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopDBusPeerSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PEER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_peer_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_freedesktop_dbus_peer_skeleton_vtable =
{
  _org_freedesktop_dbus_peer_skeleton_handle_method_call,
  _org_freedesktop_dbus_peer_skeleton_handle_get_property,
  _org_freedesktop_dbus_peer_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_freedesktop_dbus_peer_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_freedesktop_dbus_peer_interface_info ();
}

static GDBusInterfaceVTable *
org_freedesktop_dbus_peer_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_freedesktop_dbus_peer_skeleton_vtable;
}

static GVariant *
org_freedesktop_dbus_peer_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgFreedesktopDBusPeerSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PEER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_freedesktop_dbus_peer_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_freedesktop_dbus_peer_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_freedesktop_dbus_peer_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_freedesktop_dbus_peer_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.DBus.Peer", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_freedesktop_dbus_peer_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void org_freedesktop_dbus_peer_skeleton_iface_init (OrgFreedesktopDBusPeerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusPeerSkeleton, org_freedesktop_dbus_peer_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgFreedesktopDBusPeerSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_PEER, org_freedesktop_dbus_peer_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusPeerSkeleton, org_freedesktop_dbus_peer_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_PEER, org_freedesktop_dbus_peer_skeleton_iface_init))

#endif
static void
org_freedesktop_dbus_peer_skeleton_finalize (GObject *object)
{
  OrgFreedesktopDBusPeerSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PEER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_freedesktop_dbus_peer_skeleton_parent_class)->finalize (object);
}

static void
org_freedesktop_dbus_peer_skeleton_init (OrgFreedesktopDBusPeerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_freedesktop_dbus_peer_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_FREEDESKTOP_DBUS_PEER_SKELETON, OrgFreedesktopDBusPeerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_freedesktop_dbus_peer_skeleton_class_init (OrgFreedesktopDBusPeerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_freedesktop_dbus_peer_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_freedesktop_dbus_peer_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_freedesktop_dbus_peer_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_freedesktop_dbus_peer_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_freedesktop_dbus_peer_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopDBusPeerSkeletonPrivate));
#endif
}

static void
org_freedesktop_dbus_peer_skeleton_iface_init (OrgFreedesktopDBusPeerIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_freedesktop_dbus_peer_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Peer.top_of_page">org.freedesktop.DBus.Peer</link>.
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPeerSkeleton): The skeleton object.
 */
OrgFreedesktopDBusPeer *
org_freedesktop_dbus_peer_skeleton_new (void)
{
  return ORG_FREEDESKTOP_DBUS_PEER (g_object_new (TYPE_ORG_FREEDESKTOP_DBUS_PEER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.regolith.trawl1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgRegolithTrawl1
 * @title: OrgRegolithTrawl1
 * @short_description: Generated C code for the org.regolith.trawl1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-regolith-trawl1.top_of_page">org.regolith.trawl1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.regolith.trawl1 ---- */

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_load_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_load_IN_ARG_nocpp =
{
  {
    -1,
    (gchar *) "nocpp",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_load_IN_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_load_IN_ARG_path.parent_struct,
  &_org_regolith_trawl1_method_info_load_IN_ARG_nocpp.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_load =
{
  {
    -1,
    (gchar *) "Load",
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_load_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-load",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_merge_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_merge_IN_ARG_nocpp =
{
  {
    -1,
    (gchar *) "nocpp",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_merge_IN_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_merge_IN_ARG_path.parent_struct,
  &_org_regolith_trawl1_method_info_merge_IN_ARG_nocpp.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_merge =
{
  {
    -1,
    (gchar *) "Merge",
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_merge_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-merge",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_load_cpp_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_load_cpp_IN_ARG_cpp =
{
  {
    -1,
    (gchar *) "cpp",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_load_cpp_IN_ARG_args =
{
  {
    -1,
    (gchar *) "args",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_load_cpp_IN_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_load_cpp_IN_ARG_path.parent_struct,
  &_org_regolith_trawl1_method_info_load_cpp_IN_ARG_cpp.parent_struct,
  &_org_regolith_trawl1_method_info_load_cpp_IN_ARG_args.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_load_cpp =
{
  {
    -1,
    (gchar *) "LoadCpp",
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_load_cpp_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-load-cpp",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_merge_cpp_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_merge_cpp_IN_ARG_cpp =
{
  {
    -1,
    (gchar *) "cpp",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_merge_cpp_IN_ARG_args =
{
  {
    -1,
    (gchar *) "args",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_merge_cpp_IN_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_merge_cpp_IN_ARG_path.parent_struct,
  &_org_regolith_trawl1_method_info_merge_cpp_IN_ARG_cpp.parent_struct,
  &_org_regolith_trawl1_method_info_merge_cpp_IN_ARG_args.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_merge_cpp =
{
  {
    -1,
    (gchar *) "MergeCpp",
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_merge_cpp_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-merge-cpp",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_query_IN_ARG_q =
{
  {
    -1,
    (gchar *) "q",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_query_IN_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_query_IN_ARG_q.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_query_OUT_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_query_OUT_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_query_OUT_ARG_unnamed_arg1.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_query =
{
  {
    -1,
    (gchar *) "Query",
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_query_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_query_OUT_ARG_pointers,
    NULL
  },
  "handle-query",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_get_resource_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_get_resource_IN_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_get_resource_IN_ARG_key.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_get_resource_OUT_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_get_resource_OUT_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_get_resource_OUT_ARG_unnamed_arg1.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_get_resource =
{
  {
    -1,
    (gchar *) "GetResource",
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_get_resource_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_get_resource_OUT_ARG_pointers,
    NULL
  },
  "handle-get-resource",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_set_resource_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_set_resource_IN_ARG_val =
{
  {
    -1,
    (gchar *) "val",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_set_resource_IN_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_set_resource_IN_ARG_key.parent_struct,
  &_org_regolith_trawl1_method_info_set_resource_IN_ARG_val.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_set_resource =
{
  {
    -1,
    (gchar *) "SetResource",
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_set_resource_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-resource",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_add_resource_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_add_resource_IN_ARG_val =
{
  {
    -1,
    (gchar *) "val",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_add_resource_IN_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_add_resource_IN_ARG_key.parent_struct,
  &_org_regolith_trawl1_method_info_add_resource_IN_ARG_val.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_add_resource =
{
  {
    -1,
    (gchar *) "AddResource",
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_add_resource_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add-resource",
  FALSE
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_remove_all =
{
  {
    -1,
    (gchar *) "RemoveAll",
    NULL,
    NULL,
    NULL
  },
  "handle-remove-all",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_regolith_trawl1_method_info_remove_one_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_regolith_trawl1_method_info_remove_one_IN_ARG_pointers[] =
{
  &_org_regolith_trawl1_method_info_remove_one_IN_ARG_key.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_regolith_trawl1_method_info_remove_one =
{
  {
    -1,
    (gchar *) "RemoveOne",
    (GDBusArgInfo **) &_org_regolith_trawl1_method_info_remove_one_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-one",
  FALSE
};

static const GDBusMethodInfo * const _org_regolith_trawl1_method_info_pointers[] =
{
  &_org_regolith_trawl1_method_info_load.parent_struct,
  &_org_regolith_trawl1_method_info_merge.parent_struct,
  &_org_regolith_trawl1_method_info_load_cpp.parent_struct,
  &_org_regolith_trawl1_method_info_merge_cpp.parent_struct,
  &_org_regolith_trawl1_method_info_query.parent_struct,
  &_org_regolith_trawl1_method_info_get_resource.parent_struct,
  &_org_regolith_trawl1_method_info_set_resource.parent_struct,
  &_org_regolith_trawl1_method_info_add_resource.parent_struct,
  &_org_regolith_trawl1_method_info_remove_all.parent_struct,
  &_org_regolith_trawl1_method_info_remove_one.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _org_regolith_trawl1_property_info_resources =
{
  {
    -1,
    (gchar *) "Resources",
    (gchar *) "a{ss}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "resources",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _org_regolith_trawl1_property_info_pointers[] =
{
  &_org_regolith_trawl1_property_info_resources.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_regolith_trawl1_interface_info =
{
  {
    -1,
    (gchar *) "org.regolith.trawl1",
    (GDBusMethodInfo **) &_org_regolith_trawl1_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_org_regolith_trawl1_property_info_pointers,
    NULL
  },
  "org-regolith-trawl1",
};


/**
 * org_regolith_trawl1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-regolith-trawl1.top_of_page">org.regolith.trawl1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_regolith_trawl1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_regolith_trawl1_interface_info.parent_struct;
}

/**
 * org_regolith_trawl1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgRegolithTrawl1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_regolith_trawl1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "resources");
  return property_id_begin - 1;
}



/**
 * OrgRegolithTrawl1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-regolith-trawl1.top_of_page">org.regolith.trawl1</link>.
 */

/**
 * OrgRegolithTrawl1Iface:
 * @parent_iface: The parent interface.
 * @handle_add_resource: Handler for the #OrgRegolithTrawl1::handle-add-resource signal.
 * @handle_get_resource: Handler for the #OrgRegolithTrawl1::handle-get-resource signal.
 * @handle_load: Handler for the #OrgRegolithTrawl1::handle-load signal.
 * @handle_load_cpp: Handler for the #OrgRegolithTrawl1::handle-load-cpp signal.
 * @handle_merge: Handler for the #OrgRegolithTrawl1::handle-merge signal.
 * @handle_merge_cpp: Handler for the #OrgRegolithTrawl1::handle-merge-cpp signal.
 * @handle_query: Handler for the #OrgRegolithTrawl1::handle-query signal.
 * @handle_remove_all: Handler for the #OrgRegolithTrawl1::handle-remove-all signal.
 * @handle_remove_one: Handler for the #OrgRegolithTrawl1::handle-remove-one signal.
 * @handle_set_resource: Handler for the #OrgRegolithTrawl1::handle-set-resource signal.
 * @get_resources: Getter for the #OrgRegolithTrawl1:resources property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-regolith-trawl1.top_of_page">org.regolith.trawl1</link>.
 */

typedef OrgRegolithTrawl1Iface OrgRegolithTrawl1Interface;
G_DEFINE_INTERFACE (OrgRegolithTrawl1, org_regolith_trawl1, G_TYPE_OBJECT)

static void
org_regolith_trawl1_default_init (OrgRegolithTrawl1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgRegolithTrawl1::handle-load:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_nocpp: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.Load">Load()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_load() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-load",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_load),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * OrgRegolithTrawl1::handle-merge:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_nocpp: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.Merge">Merge()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_merge() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-merge",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_merge),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * OrgRegolithTrawl1::handle-load-cpp:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_cpp: Argument passed by remote caller.
   * @arg_args: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.LoadCpp">LoadCpp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_load_cpp() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-load-cpp",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_load_cpp),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgRegolithTrawl1::handle-merge-cpp:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_cpp: Argument passed by remote caller.
   * @arg_args: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.MergeCpp">MergeCpp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_merge_cpp() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-merge-cpp",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_merge_cpp),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgRegolithTrawl1::handle-query:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_q: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.Query">Query()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_query),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgRegolithTrawl1::handle-get-resource:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_key: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.GetResource">GetResource()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_get_resource() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-resource",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_get_resource),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * OrgRegolithTrawl1::handle-set-resource:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_key: Argument passed by remote caller.
   * @arg_val: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.SetResource">SetResource()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_set_resource() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-resource",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_set_resource),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgRegolithTrawl1::handle-add-resource:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_key: Argument passed by remote caller.
   * @arg_val: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.AddResource">AddResource()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_add_resource() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-resource",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_add_resource),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgRegolithTrawl1::handle-remove-all:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.RemoveAll">RemoveAll()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_remove_all() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-all",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_remove_all),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * OrgRegolithTrawl1::handle-remove-one:
   * @object: A #OrgRegolithTrawl1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_key: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-regolith-trawl1.RemoveOne">RemoveOne()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_regolith_trawl1_complete_remove_one() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-one",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgRegolithTrawl1Iface, handle_remove_one),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * OrgRegolithTrawl1:resources:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-regolith-trawl1.Resources">"Resources"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("resources", "Resources", "Resources", G_VARIANT_TYPE ("a{ss}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * org_regolith_trawl1_get_resources: (skip)
 * @object: A #OrgRegolithTrawl1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-regolith-trawl1.Resources">"Resources"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use org_regolith_trawl1_dup_resources() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
org_regolith_trawl1_get_resources (OrgRegolithTrawl1 *object)
{
  return ORG_REGOLITH_TRAWL1_GET_IFACE (object)->get_resources (object);
}

/**
 * org_regolith_trawl1_dup_resources: (skip)
 * @object: A #OrgRegolithTrawl1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-regolith-trawl1.Resources">"Resources"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
org_regolith_trawl1_dup_resources (OrgRegolithTrawl1 *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "resources", &value, NULL);
  return value;
}

/**
 * org_regolith_trawl1_set_resources: (skip)
 * @object: A #OrgRegolithTrawl1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-regolith-trawl1.Resources">"Resources"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
org_regolith_trawl1_set_resources (OrgRegolithTrawl1 *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "resources", value, NULL);
}

/**
 * org_regolith_trawl1_call_load:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_nocpp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.Load">Load()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_load_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_load_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_load (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_path,
    gboolean arg_nocpp,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Load",
    g_variant_new ("(sb)",
                   arg_path,
                   arg_nocpp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_load_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_load().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_load().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_load_finish (
    OrgRegolithTrawl1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_load_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_nocpp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.Load">Load()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_load() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_load_sync (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_path,
    gboolean arg_nocpp,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Load",
    g_variant_new ("(sb)",
                   arg_path,
                   arg_nocpp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_merge:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_nocpp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.Merge">Merge()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_merge_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_merge_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_merge (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_path,
    gboolean arg_nocpp,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Merge",
    g_variant_new ("(sb)",
                   arg_path,
                   arg_nocpp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_merge_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_merge().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_merge().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_merge_finish (
    OrgRegolithTrawl1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_merge_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_nocpp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.Merge">Merge()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_merge() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_merge_sync (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_path,
    gboolean arg_nocpp,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Merge",
    g_variant_new ("(sb)",
                   arg_path,
                   arg_nocpp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_load_cpp:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_cpp: Argument to pass with the method invocation.
 * @arg_args: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.LoadCpp">LoadCpp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_load_cpp_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_load_cpp_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_load_cpp (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_path,
    const gchar *arg_cpp,
    const gchar *arg_args,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LoadCpp",
    g_variant_new ("(sss)",
                   arg_path,
                   arg_cpp,
                   arg_args),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_load_cpp_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_load_cpp().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_load_cpp().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_load_cpp_finish (
    OrgRegolithTrawl1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_load_cpp_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_cpp: Argument to pass with the method invocation.
 * @arg_args: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.LoadCpp">LoadCpp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_load_cpp() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_load_cpp_sync (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_path,
    const gchar *arg_cpp,
    const gchar *arg_args,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LoadCpp",
    g_variant_new ("(sss)",
                   arg_path,
                   arg_cpp,
                   arg_args),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_merge_cpp:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_cpp: Argument to pass with the method invocation.
 * @arg_args: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.MergeCpp">MergeCpp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_merge_cpp_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_merge_cpp_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_merge_cpp (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_path,
    const gchar *arg_cpp,
    const gchar *arg_args,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MergeCpp",
    g_variant_new ("(sss)",
                   arg_path,
                   arg_cpp,
                   arg_args),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_merge_cpp_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_merge_cpp().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_merge_cpp().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_merge_cpp_finish (
    OrgRegolithTrawl1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_merge_cpp_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_cpp: Argument to pass with the method invocation.
 * @arg_args: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.MergeCpp">MergeCpp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_merge_cpp() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_merge_cpp_sync (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_path,
    const gchar *arg_cpp,
    const gchar *arg_args,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MergeCpp",
    g_variant_new ("(sss)",
                   arg_path,
                   arg_cpp,
                   arg_args),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_query:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_q: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.Query">Query()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_query_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_query_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_query (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_q,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Query",
    g_variant_new ("(s)",
                   arg_q),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_query_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_query_finish (
    OrgRegolithTrawl1 *proxy,
    gchar **out_unnamed_arg1,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_query_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_q: Argument to pass with the method invocation.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.Query">Query()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_query_sync (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_q,
    gchar **out_unnamed_arg1,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Query",
    g_variant_new ("(s)",
                   arg_q),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_get_resource:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_key: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.GetResource">GetResource()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_get_resource_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_get_resource_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_get_resource (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_key,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetResource",
    g_variant_new ("(s)",
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_get_resource_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_get_resource().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_get_resource().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_get_resource_finish (
    OrgRegolithTrawl1 *proxy,
    gchar **out_unnamed_arg1,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_get_resource_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_key: Argument to pass with the method invocation.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.GetResource">GetResource()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_get_resource() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_get_resource_sync (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_key,
    gchar **out_unnamed_arg1,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetResource",
    g_variant_new ("(s)",
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_set_resource:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_val: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.SetResource">SetResource()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_set_resource_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_set_resource_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_set_resource (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_key,
    const gchar *arg_val,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetResource",
    g_variant_new ("(ss)",
                   arg_key,
                   arg_val),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_set_resource_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_set_resource().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_set_resource().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_set_resource_finish (
    OrgRegolithTrawl1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_set_resource_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_val: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.SetResource">SetResource()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_set_resource() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_set_resource_sync (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_key,
    const gchar *arg_val,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetResource",
    g_variant_new ("(ss)",
                   arg_key,
                   arg_val),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_add_resource:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_val: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.AddResource">AddResource()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_add_resource_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_add_resource_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_add_resource (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_key,
    const gchar *arg_val,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddResource",
    g_variant_new ("(ss)",
                   arg_key,
                   arg_val),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_add_resource_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_add_resource().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_add_resource().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_add_resource_finish (
    OrgRegolithTrawl1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_add_resource_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_val: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.AddResource">AddResource()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_add_resource() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_add_resource_sync (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_key,
    const gchar *arg_val,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddResource",
    g_variant_new ("(ss)",
                   arg_key,
                   arg_val),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_remove_all:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.RemoveAll">RemoveAll()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_remove_all_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_remove_all_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_remove_all (
    OrgRegolithTrawl1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveAll",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_remove_all_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_remove_all().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_remove_all().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_remove_all_finish (
    OrgRegolithTrawl1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_remove_all_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.RemoveAll">RemoveAll()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_remove_all() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_remove_all_sync (
    OrgRegolithTrawl1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveAll",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_remove_one:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_key: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.RemoveOne">RemoveOne()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_call_remove_one_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_call_remove_one_sync() for the synchronous, blocking version of this method.
 */
void
org_regolith_trawl1_call_remove_one (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_key,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveOne",
    g_variant_new ("(s)",
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_regolith_trawl1_call_remove_one_finish:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_call_remove_one().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_regolith_trawl1_call_remove_one().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_remove_one_finish (
    OrgRegolithTrawl1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_call_remove_one_sync:
 * @proxy: A #OrgRegolithTrawl1Proxy.
 * @arg_key: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-regolith-trawl1.RemoveOne">RemoveOne()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_call_remove_one() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_regolith_trawl1_call_remove_one_sync (
    OrgRegolithTrawl1 *proxy,
    const gchar *arg_key,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveOne",
    g_variant_new ("(s)",
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_regolith_trawl1_complete_load:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.Load">Load()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_load (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_regolith_trawl1_complete_merge:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.Merge">Merge()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_merge (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_regolith_trawl1_complete_load_cpp:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.LoadCpp">LoadCpp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_load_cpp (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_regolith_trawl1_complete_merge_cpp:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.MergeCpp">MergeCpp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_merge_cpp (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_regolith_trawl1_complete_query:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg1: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.Query">Query()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_query (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *unnamed_arg1)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   unnamed_arg1));
}

/**
 * org_regolith_trawl1_complete_get_resource:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg1: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.GetResource">GetResource()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_get_resource (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *unnamed_arg1)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   unnamed_arg1));
}

/**
 * org_regolith_trawl1_complete_set_resource:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.SetResource">SetResource()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_set_resource (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_regolith_trawl1_complete_add_resource:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.AddResource">AddResource()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_add_resource (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_regolith_trawl1_complete_remove_all:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.RemoveAll">RemoveAll()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_remove_all (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_regolith_trawl1_complete_remove_one:
 * @object: A #OrgRegolithTrawl1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-regolith-trawl1.RemoveOne">RemoveOne()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_regolith_trawl1_complete_remove_one (
    OrgRegolithTrawl1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgRegolithTrawl1Proxy:
 *
 * The #OrgRegolithTrawl1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgRegolithTrawl1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgRegolithTrawl1Proxy.
 */

struct _OrgRegolithTrawl1ProxyPrivate
{
  GData *qdata;
};

static void org_regolith_trawl1_proxy_iface_init (OrgRegolithTrawl1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgRegolithTrawl1Proxy, org_regolith_trawl1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgRegolithTrawl1Proxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_REGOLITH_TRAWL1, org_regolith_trawl1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgRegolithTrawl1Proxy, org_regolith_trawl1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_REGOLITH_TRAWL1, org_regolith_trawl1_proxy_iface_init))

#endif
static void
org_regolith_trawl1_proxy_finalize (GObject *object)
{
  OrgRegolithTrawl1Proxy *proxy = ORG_REGOLITH_TRAWL1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_regolith_trawl1_proxy_parent_class)->finalize (object);
}

static void
org_regolith_trawl1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_regolith_trawl1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
org_regolith_trawl1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.regolith.trawl1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
org_regolith_trawl1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_regolith_trawl1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.regolith.trawl1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) org_regolith_trawl1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
org_regolith_trawl1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_regolith_trawl1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_REGOLITH_TRAWL1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_REGOLITH_TRAWL1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_regolith_trawl1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgRegolithTrawl1Proxy *proxy = ORG_REGOLITH_TRAWL1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_regolith_trawl1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_regolith_trawl1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static GVariant *
org_regolith_trawl1_proxy_get_resources (OrgRegolithTrawl1 *object)
{
  OrgRegolithTrawl1Proxy *proxy = ORG_REGOLITH_TRAWL1_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Resources");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
org_regolith_trawl1_proxy_init (OrgRegolithTrawl1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_regolith_trawl1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_REGOLITH_TRAWL1_PROXY, OrgRegolithTrawl1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_regolith_trawl1_interface_info ());
}

static void
org_regolith_trawl1_proxy_class_init (OrgRegolithTrawl1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_regolith_trawl1_proxy_finalize;
  gobject_class->get_property = org_regolith_trawl1_proxy_get_property;
  gobject_class->set_property = org_regolith_trawl1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_regolith_trawl1_proxy_g_signal;
  proxy_class->g_properties_changed = org_regolith_trawl1_proxy_g_properties_changed;

  org_regolith_trawl1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgRegolithTrawl1ProxyPrivate));
#endif
}

static void
org_regolith_trawl1_proxy_iface_init (OrgRegolithTrawl1Iface *iface)
{
  iface->get_resources = org_regolith_trawl1_proxy_get_resources;
}

/**
 * org_regolith_trawl1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-regolith-trawl1.top_of_page">org.regolith.trawl1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_proxy_new_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_regolith_trawl1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_REGOLITH_TRAWL1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.regolith.trawl1", NULL);
}

/**
 * org_regolith_trawl1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_regolith_trawl1_proxy_new().
 *
 * Returns: (transfer full) (type OrgRegolithTrawl1Proxy): The constructed proxy object or %NULL if @error is set.
 */
OrgRegolithTrawl1 *
org_regolith_trawl1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_REGOLITH_TRAWL1 (ret);
  else
    return NULL;
}

/**
 * org_regolith_trawl1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-regolith-trawl1.top_of_page">org.regolith.trawl1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgRegolithTrawl1Proxy): The constructed proxy object or %NULL if @error is set.
 */
OrgRegolithTrawl1 *
org_regolith_trawl1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_REGOLITH_TRAWL1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.regolith.trawl1", NULL);
  if (ret != NULL)
    return ORG_REGOLITH_TRAWL1 (ret);
  else
    return NULL;
}


/**
 * org_regolith_trawl1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_regolith_trawl1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_regolith_trawl1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_regolith_trawl1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_regolith_trawl1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_REGOLITH_TRAWL1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.regolith.trawl1", NULL);
}

/**
 * org_regolith_trawl1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_regolith_trawl1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_regolith_trawl1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgRegolithTrawl1Proxy): The constructed proxy object or %NULL if @error is set.
 */
OrgRegolithTrawl1 *
org_regolith_trawl1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_REGOLITH_TRAWL1 (ret);
  else
    return NULL;
}

/**
 * org_regolith_trawl1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_regolith_trawl1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_regolith_trawl1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgRegolithTrawl1Proxy): The constructed proxy object or %NULL if @error is set.
 */
OrgRegolithTrawl1 *
org_regolith_trawl1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_REGOLITH_TRAWL1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.regolith.trawl1", NULL);
  if (ret != NULL)
    return ORG_REGOLITH_TRAWL1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgRegolithTrawl1Skeleton:
 *
 * The #OrgRegolithTrawl1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgRegolithTrawl1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgRegolithTrawl1Skeleton.
 */

struct _OrgRegolithTrawl1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_regolith_trawl1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_REGOLITH_TRAWL1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_REGOLITH_TRAWL1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_regolith_trawl1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_regolith_trawl1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_regolith_trawl1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_regolith_trawl1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_regolith_trawl1_skeleton_vtable =
{
  _org_regolith_trawl1_skeleton_handle_method_call,
  _org_regolith_trawl1_skeleton_handle_get_property,
  _org_regolith_trawl1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_regolith_trawl1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_regolith_trawl1_interface_info ();
}

static GDBusInterfaceVTable *
org_regolith_trawl1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_regolith_trawl1_skeleton_vtable;
}

static GVariant *
org_regolith_trawl1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_regolith_trawl1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_regolith_trawl1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_regolith_trawl1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_regolith_trawl1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.regolith.trawl1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _org_regolith_trawl1_emit_changed (gpointer user_data);

static void
org_regolith_trawl1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _org_regolith_trawl1_emit_changed (skeleton);
}

static void org_regolith_trawl1_skeleton_iface_init (OrgRegolithTrawl1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgRegolithTrawl1Skeleton, org_regolith_trawl1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgRegolithTrawl1Skeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_REGOLITH_TRAWL1, org_regolith_trawl1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgRegolithTrawl1Skeleton, org_regolith_trawl1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_REGOLITH_TRAWL1, org_regolith_trawl1_skeleton_iface_init))

#endif
static void
org_regolith_trawl1_skeleton_finalize (GObject *object)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_regolith_trawl1_skeleton_parent_class)->finalize (object);
}

static void
org_regolith_trawl1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_org_regolith_trawl1_emit_changed (gpointer user_data)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.regolith.trawl1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_org_regolith_trawl1_schedule_emit_changed (OrgRegolithTrawl1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
org_regolith_trawl1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _org_regolith_trawl1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _org_regolith_trawl1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
org_regolith_trawl1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _org_regolith_trawl1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _org_regolith_trawl1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
org_regolith_trawl1_skeleton_init (OrgRegolithTrawl1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_regolith_trawl1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_REGOLITH_TRAWL1_SKELETON, OrgRegolithTrawl1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_VARIANT);
}

static GVariant *
org_regolith_trawl1_skeleton_get_resources (OrgRegolithTrawl1 *object)
{
  OrgRegolithTrawl1Skeleton *skeleton = ORG_REGOLITH_TRAWL1_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
org_regolith_trawl1_skeleton_class_init (OrgRegolithTrawl1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_regolith_trawl1_skeleton_finalize;
  gobject_class->get_property = org_regolith_trawl1_skeleton_get_property;
  gobject_class->set_property = org_regolith_trawl1_skeleton_set_property;
  gobject_class->notify       = org_regolith_trawl1_skeleton_notify;


  org_regolith_trawl1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_regolith_trawl1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_regolith_trawl1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_regolith_trawl1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_regolith_trawl1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgRegolithTrawl1SkeletonPrivate));
#endif
}

static void
org_regolith_trawl1_skeleton_iface_init (OrgRegolithTrawl1Iface *iface)
{
  iface->get_resources = org_regolith_trawl1_skeleton_get_resources;
}

/**
 * org_regolith_trawl1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-regolith-trawl1.top_of_page">org.regolith.trawl1</link>.
 *
 * Returns: (transfer full) (type OrgRegolithTrawl1Skeleton): The skeleton object.
 */
OrgRegolithTrawl1 *
org_regolith_trawl1_skeleton_new (void)
{
  return ORG_REGOLITH_TRAWL1 (g_object_new (TYPE_ORG_REGOLITH_TRAWL1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.DBus.Introspectable
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgFreedesktopDBusIntrospectable
 * @title: OrgFreedesktopDBusIntrospectable
 * @short_description: Generated C code for the org.freedesktop.DBus.Introspectable D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.DBus.Introspectable ---- */

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_introspectable_method_info_introspect_OUT_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_dbus_introspectable_method_info_introspect_OUT_ARG_pointers[] =
{
  &_org_freedesktop_dbus_introspectable_method_info_introspect_OUT_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_dbus_introspectable_method_info_introspect =
{
  {
    -1,
    (gchar *) "Introspect",
    NULL,
    (GDBusArgInfo **) &_org_freedesktop_dbus_introspectable_method_info_introspect_OUT_ARG_pointers,
    NULL
  },
  "handle-introspect",
  FALSE
};

static const GDBusMethodInfo * const _org_freedesktop_dbus_introspectable_method_info_pointers[] =
{
  &_org_freedesktop_dbus_introspectable_method_info_introspect.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_freedesktop_dbus_introspectable_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.DBus.Introspectable",
    (GDBusMethodInfo **) &_org_freedesktop_dbus_introspectable_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "org-freedesktop-dbus-introspectable",
};


/**
 * org_freedesktop_dbus_introspectable_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_freedesktop_dbus_introspectable_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_freedesktop_dbus_introspectable_interface_info.parent_struct;
}

/**
 * org_freedesktop_dbus_introspectable_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgFreedesktopDBusIntrospectable interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_freedesktop_dbus_introspectable_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * OrgFreedesktopDBusIntrospectable:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>.
 */

/**
 * OrgFreedesktopDBusIntrospectableIface:
 * @parent_iface: The parent interface.
 * @handle_introspect: Handler for the #OrgFreedesktopDBusIntrospectable::handle-introspect signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>.
 */

typedef OrgFreedesktopDBusIntrospectableIface OrgFreedesktopDBusIntrospectableInterface;
G_DEFINE_INTERFACE (OrgFreedesktopDBusIntrospectable, org_freedesktop_dbus_introspectable, G_TYPE_OBJECT)

static void
org_freedesktop_dbus_introspectable_default_init (OrgFreedesktopDBusIntrospectableIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgFreedesktopDBusIntrospectable::handle-introspect:
   * @object: A #OrgFreedesktopDBusIntrospectable.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DBus-Introspectable.Introspect">Introspect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_dbus_introspectable_complete_introspect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-introspect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopDBusIntrospectableIface, handle_introspect),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * org_freedesktop_dbus_introspectable_call_introspect:
 * @proxy: A #OrgFreedesktopDBusIntrospectableProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Introspectable.Introspect">Introspect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_introspectable_call_introspect_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_introspectable_call_introspect_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_dbus_introspectable_call_introspect (
    OrgFreedesktopDBusIntrospectable *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Introspect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_dbus_introspectable_call_introspect_finish:
 * @proxy: A #OrgFreedesktopDBusIntrospectableProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_introspectable_call_introspect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_dbus_introspectable_call_introspect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_introspectable_call_introspect_finish (
    OrgFreedesktopDBusIntrospectable *proxy,
    gchar **out_unnamed_arg0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_introspectable_call_introspect_sync:
 * @proxy: A #OrgFreedesktopDBusIntrospectableProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Introspectable.Introspect">Introspect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_introspectable_call_introspect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_introspectable_call_introspect_sync (
    OrgFreedesktopDBusIntrospectable *proxy,
    gchar **out_unnamed_arg0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Introspect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_introspectable_complete_introspect:
 * @object: A #OrgFreedesktopDBusIntrospectable.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DBus-Introspectable.Introspect">Introspect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_dbus_introspectable_complete_introspect (
    OrgFreedesktopDBusIntrospectable *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *unnamed_arg0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   unnamed_arg0));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopDBusIntrospectableProxy:
 *
 * The #OrgFreedesktopDBusIntrospectableProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopDBusIntrospectableProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopDBusIntrospectableProxy.
 */

struct _OrgFreedesktopDBusIntrospectableProxyPrivate
{
  GData *qdata;
};

static void org_freedesktop_dbus_introspectable_proxy_iface_init (OrgFreedesktopDBusIntrospectableIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusIntrospectableProxy, org_freedesktop_dbus_introspectable_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgFreedesktopDBusIntrospectableProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE, org_freedesktop_dbus_introspectable_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusIntrospectableProxy, org_freedesktop_dbus_introspectable_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE, org_freedesktop_dbus_introspectable_proxy_iface_init))

#endif
static void
org_freedesktop_dbus_introspectable_proxy_finalize (GObject *object)
{
  OrgFreedesktopDBusIntrospectableProxy *proxy = ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_freedesktop_dbus_introspectable_proxy_parent_class)->finalize (object);
}

static void
org_freedesktop_dbus_introspectable_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_freedesktop_dbus_introspectable_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_freedesktop_dbus_introspectable_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_introspectable_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_freedesktop_dbus_introspectable_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgFreedesktopDBusIntrospectableProxy *proxy = ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_introspectable_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_introspectable_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_freedesktop_dbus_introspectable_proxy_init (OrgFreedesktopDBusIntrospectableProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_freedesktop_dbus_introspectable_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_PROXY, OrgFreedesktopDBusIntrospectableProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_freedesktop_dbus_introspectable_interface_info ());
}

static void
org_freedesktop_dbus_introspectable_proxy_class_init (OrgFreedesktopDBusIntrospectableProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_freedesktop_dbus_introspectable_proxy_finalize;
  gobject_class->get_property = org_freedesktop_dbus_introspectable_proxy_get_property;
  gobject_class->set_property = org_freedesktop_dbus_introspectable_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_freedesktop_dbus_introspectable_proxy_g_signal;
  proxy_class->g_properties_changed = org_freedesktop_dbus_introspectable_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopDBusIntrospectableProxyPrivate));
#endif
}

static void
org_freedesktop_dbus_introspectable_proxy_iface_init (OrgFreedesktopDBusIntrospectableIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_freedesktop_dbus_introspectable_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_introspectable_proxy_new_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_introspectable_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_dbus_introspectable_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
}

/**
 * org_freedesktop_dbus_introspectable_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_introspectable_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_dbus_introspectable_proxy_new().
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusIntrospectableProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusIntrospectable *
org_freedesktop_dbus_introspectable_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_INTROSPECTABLE (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_dbus_introspectable_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_introspectable_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusIntrospectableProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusIntrospectable *
org_freedesktop_dbus_introspectable_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_INTROSPECTABLE (ret);
  else
    return NULL;
}


/**
 * org_freedesktop_dbus_introspectable_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_freedesktop_dbus_introspectable_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_introspectable_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_introspectable_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_dbus_introspectable_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
}

/**
 * org_freedesktop_dbus_introspectable_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_introspectable_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_dbus_introspectable_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusIntrospectableProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusIntrospectable *
org_freedesktop_dbus_introspectable_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_INTROSPECTABLE (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_dbus_introspectable_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_freedesktop_dbus_introspectable_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_introspectable_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusIntrospectableProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusIntrospectable *
org_freedesktop_dbus_introspectable_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_INTROSPECTABLE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopDBusIntrospectableSkeleton:
 *
 * The #OrgFreedesktopDBusIntrospectableSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopDBusIntrospectableSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopDBusIntrospectableSkeleton.
 */

struct _OrgFreedesktopDBusIntrospectableSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_freedesktop_dbus_introspectable_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgFreedesktopDBusIntrospectableSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_freedesktop_dbus_introspectable_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopDBusIntrospectableSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_introspectable_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_freedesktop_dbus_introspectable_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopDBusIntrospectableSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_introspectable_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_freedesktop_dbus_introspectable_skeleton_vtable =
{
  _org_freedesktop_dbus_introspectable_skeleton_handle_method_call,
  _org_freedesktop_dbus_introspectable_skeleton_handle_get_property,
  _org_freedesktop_dbus_introspectable_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_freedesktop_dbus_introspectable_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_freedesktop_dbus_introspectable_interface_info ();
}

static GDBusInterfaceVTable *
org_freedesktop_dbus_introspectable_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_freedesktop_dbus_introspectable_skeleton_vtable;
}

static GVariant *
org_freedesktop_dbus_introspectable_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgFreedesktopDBusIntrospectableSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_freedesktop_dbus_introspectable_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_freedesktop_dbus_introspectable_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_freedesktop_dbus_introspectable_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_freedesktop_dbus_introspectable_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.DBus.Introspectable", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_freedesktop_dbus_introspectable_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void org_freedesktop_dbus_introspectable_skeleton_iface_init (OrgFreedesktopDBusIntrospectableIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusIntrospectableSkeleton, org_freedesktop_dbus_introspectable_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgFreedesktopDBusIntrospectableSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE, org_freedesktop_dbus_introspectable_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusIntrospectableSkeleton, org_freedesktop_dbus_introspectable_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE, org_freedesktop_dbus_introspectable_skeleton_iface_init))

#endif
static void
org_freedesktop_dbus_introspectable_skeleton_finalize (GObject *object)
{
  OrgFreedesktopDBusIntrospectableSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_freedesktop_dbus_introspectable_skeleton_parent_class)->finalize (object);
}

static void
org_freedesktop_dbus_introspectable_skeleton_init (OrgFreedesktopDBusIntrospectableSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_freedesktop_dbus_introspectable_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_SKELETON, OrgFreedesktopDBusIntrospectableSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_freedesktop_dbus_introspectable_skeleton_class_init (OrgFreedesktopDBusIntrospectableSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_freedesktop_dbus_introspectable_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_freedesktop_dbus_introspectable_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_freedesktop_dbus_introspectable_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_freedesktop_dbus_introspectable_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_freedesktop_dbus_introspectable_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopDBusIntrospectableSkeletonPrivate));
#endif
}

static void
org_freedesktop_dbus_introspectable_skeleton_iface_init (OrgFreedesktopDBusIntrospectableIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_freedesktop_dbus_introspectable_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>.
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusIntrospectableSkeleton): The skeleton object.
 */
OrgFreedesktopDBusIntrospectable *
org_freedesktop_dbus_introspectable_skeleton_new (void)
{
  return ORG_FREEDESKTOP_DBUS_INTROSPECTABLE (g_object_new (TYPE_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.DBus.Properties
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:OrgFreedesktopDBusProperties
 * @title: OrgFreedesktopDBusProperties
 * @short_description: Generated C code for the org.freedesktop.DBus.Properties D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.DBus.Properties ---- */

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_method_info_get_IN_ARG_interface_name =
{
  {
    -1,
    (gchar *) "interface_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_method_info_get_IN_ARG_property_name =
{
  {
    -1,
    (gchar *) "property_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_dbus_properties_method_info_get_IN_ARG_pointers[] =
{
  &_org_freedesktop_dbus_properties_method_info_get_IN_ARG_interface_name.parent_struct,
  &_org_freedesktop_dbus_properties_method_info_get_IN_ARG_property_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_method_info_get_OUT_ARG_unnamed_arg2 =
{
  {
    -1,
    (gchar *) "unnamed_arg2",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_dbus_properties_method_info_get_OUT_ARG_pointers[] =
{
  &_org_freedesktop_dbus_properties_method_info_get_OUT_ARG_unnamed_arg2.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_dbus_properties_method_info_get =
{
  {
    -1,
    (gchar *) "Get",
    (GDBusArgInfo **) &_org_freedesktop_dbus_properties_method_info_get_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_freedesktop_dbus_properties_method_info_get_OUT_ARG_pointers,
    NULL
  },
  "handle-get",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_method_info_set_IN_ARG_interface_name =
{
  {
    -1,
    (gchar *) "interface_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_method_info_set_IN_ARG_property_name =
{
  {
    -1,
    (gchar *) "property_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_method_info_set_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_dbus_properties_method_info_set_IN_ARG_pointers[] =
{
  &_org_freedesktop_dbus_properties_method_info_set_IN_ARG_interface_name.parent_struct,
  &_org_freedesktop_dbus_properties_method_info_set_IN_ARG_property_name.parent_struct,
  &_org_freedesktop_dbus_properties_method_info_set_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_dbus_properties_method_info_set =
{
  {
    -1,
    (gchar *) "Set",
    (GDBusArgInfo **) &_org_freedesktop_dbus_properties_method_info_set_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set",
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_method_info_get_all_IN_ARG_interface_name =
{
  {
    -1,
    (gchar *) "interface_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_dbus_properties_method_info_get_all_IN_ARG_pointers[] =
{
  &_org_freedesktop_dbus_properties_method_info_get_all_IN_ARG_interface_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_method_info_get_all_OUT_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_dbus_properties_method_info_get_all_OUT_ARG_pointers[] =
{
  &_org_freedesktop_dbus_properties_method_info_get_all_OUT_ARG_unnamed_arg1.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _org_freedesktop_dbus_properties_method_info_get_all =
{
  {
    -1,
    (gchar *) "GetAll",
    (GDBusArgInfo **) &_org_freedesktop_dbus_properties_method_info_get_all_IN_ARG_pointers,
    (GDBusArgInfo **) &_org_freedesktop_dbus_properties_method_info_get_all_OUT_ARG_pointers,
    NULL
  },
  "handle-get-all",
  FALSE
};

static const GDBusMethodInfo * const _org_freedesktop_dbus_properties_method_info_pointers[] =
{
  &_org_freedesktop_dbus_properties_method_info_get.parent_struct,
  &_org_freedesktop_dbus_properties_method_info_set.parent_struct,
  &_org_freedesktop_dbus_properties_method_info_get_all.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_signal_info_properties_changed_ARG_interface_name =
{
  {
    -1,
    (gchar *) "interface_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_signal_info_properties_changed_ARG_changed_properties =
{
  {
    -1,
    (gchar *) "changed_properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _org_freedesktop_dbus_properties_signal_info_properties_changed_ARG_invalidated_properties =
{
  {
    -1,
    (gchar *) "invalidated_properties",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _org_freedesktop_dbus_properties_signal_info_properties_changed_ARG_pointers[] =
{
  &_org_freedesktop_dbus_properties_signal_info_properties_changed_ARG_interface_name.parent_struct,
  &_org_freedesktop_dbus_properties_signal_info_properties_changed_ARG_changed_properties.parent_struct,
  &_org_freedesktop_dbus_properties_signal_info_properties_changed_ARG_invalidated_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _org_freedesktop_dbus_properties_signal_info_properties_changed =
{
  {
    -1,
    (gchar *) "PropertiesChanged",
    (GDBusArgInfo **) &_org_freedesktop_dbus_properties_signal_info_properties_changed_ARG_pointers,
    NULL
  },
  "properties-changed"
};

static const GDBusSignalInfo * const _org_freedesktop_dbus_properties_signal_info_pointers[] =
{
  &_org_freedesktop_dbus_properties_signal_info_properties_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _org_freedesktop_dbus_properties_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.DBus.Properties",
    (GDBusMethodInfo **) &_org_freedesktop_dbus_properties_method_info_pointers,
    (GDBusSignalInfo **) &_org_freedesktop_dbus_properties_signal_info_pointers,
    NULL,
    NULL
  },
  "org-freedesktop-dbus-properties",
};


/**
 * org_freedesktop_dbus_properties_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
org_freedesktop_dbus_properties_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_org_freedesktop_dbus_properties_interface_info.parent_struct;
}

/**
 * org_freedesktop_dbus_properties_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #OrgFreedesktopDBusProperties interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
org_freedesktop_dbus_properties_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * OrgFreedesktopDBusProperties:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>.
 */

/**
 * OrgFreedesktopDBusPropertiesIface:
 * @parent_iface: The parent interface.
 * @handle_get: Handler for the #OrgFreedesktopDBusProperties::handle-get signal.
 * @handle_get_all: Handler for the #OrgFreedesktopDBusProperties::handle-get-all signal.
 * @handle_set: Handler for the #OrgFreedesktopDBusProperties::handle-set signal.
 * @properties_changed: Handler for the #OrgFreedesktopDBusProperties::properties-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>.
 */

typedef OrgFreedesktopDBusPropertiesIface OrgFreedesktopDBusPropertiesInterface;
G_DEFINE_INTERFACE (OrgFreedesktopDBusProperties, org_freedesktop_dbus_properties, G_TYPE_OBJECT)

static void
org_freedesktop_dbus_properties_default_init (OrgFreedesktopDBusPropertiesIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * OrgFreedesktopDBusProperties::handle-get:
   * @object: A #OrgFreedesktopDBusProperties.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interface_name: Argument passed by remote caller.
   * @arg_property_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Get">Get()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_dbus_properties_complete_get() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopDBusPropertiesIface, handle_get),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * OrgFreedesktopDBusProperties::handle-set:
   * @object: A #OrgFreedesktopDBusProperties.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interface_name: Argument passed by remote caller.
   * @arg_property_name: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Set">Set()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_dbus_properties_complete_set() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopDBusPropertiesIface, handle_set),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * OrgFreedesktopDBusProperties::handle-get-all:
   * @object: A #OrgFreedesktopDBusProperties.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interface_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.GetAll">GetAll()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call org_freedesktop_dbus_properties_complete_get_all() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-all",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopDBusPropertiesIface, handle_get_all),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * OrgFreedesktopDBusProperties::properties-changed:
   * @object: A #OrgFreedesktopDBusProperties.
   * @arg_interface_name: Argument.
   * @arg_changed_properties: Argument.
   * @arg_invalidated_properties: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-DBus-Properties.PropertiesChanged">"PropertiesChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("properties-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (OrgFreedesktopDBusPropertiesIface, properties_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_STRV);

}

/**
 * org_freedesktop_dbus_properties_emit_properties_changed:
 * @object: A #OrgFreedesktopDBusProperties.
 * @arg_interface_name: Argument to pass with the signal.
 * @arg_changed_properties: Argument to pass with the signal.
 * @arg_invalidated_properties: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-DBus-Properties.PropertiesChanged">"PropertiesChanged"</link> D-Bus signal.
 */
void
org_freedesktop_dbus_properties_emit_properties_changed (
    OrgFreedesktopDBusProperties *object,
    const gchar *arg_interface_name,
    GVariant *arg_changed_properties,
    const gchar *const *arg_invalidated_properties)
{
  g_signal_emit_by_name (object, "properties-changed", arg_interface_name, arg_changed_properties, arg_invalidated_properties);
}

/**
 * org_freedesktop_dbus_properties_call_get:
 * @proxy: A #OrgFreedesktopDBusPropertiesProxy.
 * @arg_interface_name: Argument to pass with the method invocation.
 * @arg_property_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Get">Get()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_properties_call_get_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_properties_call_get_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_dbus_properties_call_get (
    OrgFreedesktopDBusProperties *proxy,
    const gchar *arg_interface_name,
    const gchar *arg_property_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Get",
    g_variant_new ("(ss)",
                   arg_interface_name,
                   arg_property_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_dbus_properties_call_get_finish:
 * @proxy: A #OrgFreedesktopDBusPropertiesProxy.
 * @out_unnamed_arg2: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_properties_call_get().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_dbus_properties_call_get().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_properties_call_get_finish (
    OrgFreedesktopDBusProperties *proxy,
    GVariant **out_unnamed_arg2,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_unnamed_arg2);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_properties_call_get_sync:
 * @proxy: A #OrgFreedesktopDBusPropertiesProxy.
 * @arg_interface_name: Argument to pass with the method invocation.
 * @arg_property_name: Argument to pass with the method invocation.
 * @out_unnamed_arg2: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Get">Get()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_properties_call_get() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_properties_call_get_sync (
    OrgFreedesktopDBusProperties *proxy,
    const gchar *arg_interface_name,
    const gchar *arg_property_name,
    GVariant **out_unnamed_arg2,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Get",
    g_variant_new ("(ss)",
                   arg_interface_name,
                   arg_property_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_unnamed_arg2);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_properties_call_set:
 * @proxy: A #OrgFreedesktopDBusPropertiesProxy.
 * @arg_interface_name: Argument to pass with the method invocation.
 * @arg_property_name: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Set">Set()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_properties_call_set_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_properties_call_set_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_dbus_properties_call_set (
    OrgFreedesktopDBusProperties *proxy,
    const gchar *arg_interface_name,
    const gchar *arg_property_name,
    GVariant *arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(ss@v)",
                   arg_interface_name,
                   arg_property_name,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_dbus_properties_call_set_finish:
 * @proxy: A #OrgFreedesktopDBusPropertiesProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_properties_call_set().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_dbus_properties_call_set().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_properties_call_set_finish (
    OrgFreedesktopDBusProperties *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_properties_call_set_sync:
 * @proxy: A #OrgFreedesktopDBusPropertiesProxy.
 * @arg_interface_name: Argument to pass with the method invocation.
 * @arg_property_name: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Set">Set()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_properties_call_set() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_properties_call_set_sync (
    OrgFreedesktopDBusProperties *proxy,
    const gchar *arg_interface_name,
    const gchar *arg_property_name,
    GVariant *arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(ss@v)",
                   arg_interface_name,
                   arg_property_name,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_properties_call_get_all:
 * @proxy: A #OrgFreedesktopDBusPropertiesProxy.
 * @arg_interface_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.GetAll">GetAll()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_properties_call_get_all_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_properties_call_get_all_sync() for the synchronous, blocking version of this method.
 */
void
org_freedesktop_dbus_properties_call_get_all (
    OrgFreedesktopDBusProperties *proxy,
    const gchar *arg_interface_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAll",
    g_variant_new ("(s)",
                   arg_interface_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * org_freedesktop_dbus_properties_call_get_all_finish:
 * @proxy: A #OrgFreedesktopDBusPropertiesProxy.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_properties_call_get_all().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with org_freedesktop_dbus_properties_call_get_all().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_properties_call_get_all_finish (
    OrgFreedesktopDBusProperties *proxy,
    GVariant **out_unnamed_arg1,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_properties_call_get_all_sync:
 * @proxy: A #OrgFreedesktopDBusPropertiesProxy.
 * @arg_interface_name: Argument to pass with the method invocation.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.GetAll">GetAll()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_properties_call_get_all() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
org_freedesktop_dbus_properties_call_get_all_sync (
    OrgFreedesktopDBusProperties *proxy,
    const gchar *arg_interface_name,
    GVariant **out_unnamed_arg1,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAll",
    g_variant_new ("(s)",
                   arg_interface_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * org_freedesktop_dbus_properties_complete_get:
 * @object: A #OrgFreedesktopDBusProperties.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg2: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Get">Get()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_dbus_properties_complete_get (
    OrgFreedesktopDBusProperties *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *unnamed_arg2)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@v)",
                   unnamed_arg2));
}

/**
 * org_freedesktop_dbus_properties_complete_set:
 * @object: A #OrgFreedesktopDBusProperties.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Set">Set()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_dbus_properties_complete_set (
    OrgFreedesktopDBusProperties *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * org_freedesktop_dbus_properties_complete_get_all:
 * @object: A #OrgFreedesktopDBusProperties.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg1: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.GetAll">GetAll()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
org_freedesktop_dbus_properties_complete_get_all (
    OrgFreedesktopDBusProperties *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *unnamed_arg1)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   unnamed_arg1));
}

/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopDBusPropertiesProxy:
 *
 * The #OrgFreedesktopDBusPropertiesProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopDBusPropertiesProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopDBusPropertiesProxy.
 */

struct _OrgFreedesktopDBusPropertiesProxyPrivate
{
  GData *qdata;
};

static void org_freedesktop_dbus_properties_proxy_iface_init (OrgFreedesktopDBusPropertiesIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusPropertiesProxy, org_freedesktop_dbus_properties_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (OrgFreedesktopDBusPropertiesProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES, org_freedesktop_dbus_properties_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusPropertiesProxy, org_freedesktop_dbus_properties_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES, org_freedesktop_dbus_properties_proxy_iface_init))

#endif
static void
org_freedesktop_dbus_properties_proxy_finalize (GObject *object)
{
  OrgFreedesktopDBusPropertiesProxy *proxy = ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (org_freedesktop_dbus_properties_proxy_parent_class)->finalize (object);
}

static void
org_freedesktop_dbus_properties_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_freedesktop_dbus_properties_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
org_freedesktop_dbus_properties_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_properties_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
org_freedesktop_dbus_properties_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  OrgFreedesktopDBusPropertiesProxy *proxy = ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_properties_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_properties_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
org_freedesktop_dbus_properties_proxy_init (OrgFreedesktopDBusPropertiesProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = org_freedesktop_dbus_properties_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY, OrgFreedesktopDBusPropertiesProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), org_freedesktop_dbus_properties_interface_info ());
}

static void
org_freedesktop_dbus_properties_proxy_class_init (OrgFreedesktopDBusPropertiesProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = org_freedesktop_dbus_properties_proxy_finalize;
  gobject_class->get_property = org_freedesktop_dbus_properties_proxy_get_property;
  gobject_class->set_property = org_freedesktop_dbus_properties_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = org_freedesktop_dbus_properties_proxy_g_signal;
  proxy_class->g_properties_changed = org_freedesktop_dbus_properties_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopDBusPropertiesProxyPrivate));
#endif
}

static void
org_freedesktop_dbus_properties_proxy_iface_init (OrgFreedesktopDBusPropertiesIface *iface G_GNUC_UNUSED)
{
}

/**
 * org_freedesktop_dbus_properties_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_properties_proxy_new_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_properties_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_dbus_properties_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
}

/**
 * org_freedesktop_dbus_properties_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_properties_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_dbus_properties_proxy_new().
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPropertiesProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusProperties *
org_freedesktop_dbus_properties_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_PROPERTIES (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_dbus_properties_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_properties_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPropertiesProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusProperties *
org_freedesktop_dbus_properties_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_PROPERTIES (ret);
  else
    return NULL;
}


/**
 * org_freedesktop_dbus_properties_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like org_freedesktop_dbus_properties_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call org_freedesktop_dbus_properties_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See org_freedesktop_dbus_properties_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
org_freedesktop_dbus_properties_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
}

/**
 * org_freedesktop_dbus_properties_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to org_freedesktop_dbus_properties_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with org_freedesktop_dbus_properties_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPropertiesProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusProperties *
org_freedesktop_dbus_properties_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_PROPERTIES (ret);
  else
    return NULL;
}

/**
 * org_freedesktop_dbus_properties_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like org_freedesktop_dbus_properties_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See org_freedesktop_dbus_properties_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPropertiesProxy): The constructed proxy object or %NULL if @error is set.
 */
OrgFreedesktopDBusProperties *
org_freedesktop_dbus_properties_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
  if (ret != NULL)
    return ORG_FREEDESKTOP_DBUS_PROPERTIES (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * OrgFreedesktopDBusPropertiesSkeleton:
 *
 * The #OrgFreedesktopDBusPropertiesSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * OrgFreedesktopDBusPropertiesSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #OrgFreedesktopDBusPropertiesSkeleton.
 */

struct _OrgFreedesktopDBusPropertiesSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_org_freedesktop_dbus_properties_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  OrgFreedesktopDBusPropertiesSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PROPERTIES_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_org_freedesktop_dbus_properties_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopDBusPropertiesSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PROPERTIES_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_properties_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_org_freedesktop_dbus_properties_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  OrgFreedesktopDBusPropertiesSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PROPERTIES_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_org_freedesktop_dbus_properties_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _org_freedesktop_dbus_properties_skeleton_vtable =
{
  _org_freedesktop_dbus_properties_skeleton_handle_method_call,
  _org_freedesktop_dbus_properties_skeleton_handle_get_property,
  _org_freedesktop_dbus_properties_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
org_freedesktop_dbus_properties_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return org_freedesktop_dbus_properties_interface_info ();
}

static GDBusInterfaceVTable *
org_freedesktop_dbus_properties_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_org_freedesktop_dbus_properties_skeleton_vtable;
}

static GVariant *
org_freedesktop_dbus_properties_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  OrgFreedesktopDBusPropertiesSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PROPERTIES_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_org_freedesktop_dbus_properties_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _org_freedesktop_dbus_properties_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _org_freedesktop_dbus_properties_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _org_freedesktop_dbus_properties_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.DBus.Properties", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
org_freedesktop_dbus_properties_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_org_freedesktop_dbus_properties_on_signal_properties_changed (
    OrgFreedesktopDBusProperties *object,
    const gchar *arg_interface_name,
    GVariant *arg_changed_properties,
    const gchar *const *arg_invalidated_properties)
{
  OrgFreedesktopDBusPropertiesSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PROPERTIES_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@a{sv}^as)",
                   arg_interface_name,
                   arg_changed_properties,
                   arg_invalidated_properties));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.DBus.Properties", "PropertiesChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void org_freedesktop_dbus_properties_skeleton_iface_init (OrgFreedesktopDBusPropertiesIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusPropertiesSkeleton, org_freedesktop_dbus_properties_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (OrgFreedesktopDBusPropertiesSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES, org_freedesktop_dbus_properties_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (OrgFreedesktopDBusPropertiesSkeleton, org_freedesktop_dbus_properties_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES, org_freedesktop_dbus_properties_skeleton_iface_init))

#endif
static void
org_freedesktop_dbus_properties_skeleton_finalize (GObject *object)
{
  OrgFreedesktopDBusPropertiesSkeleton *skeleton = ORG_FREEDESKTOP_DBUS_PROPERTIES_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (org_freedesktop_dbus_properties_skeleton_parent_class)->finalize (object);
}

static void
org_freedesktop_dbus_properties_skeleton_init (OrgFreedesktopDBusPropertiesSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = org_freedesktop_dbus_properties_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES_SKELETON, OrgFreedesktopDBusPropertiesSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
org_freedesktop_dbus_properties_skeleton_class_init (OrgFreedesktopDBusPropertiesSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = org_freedesktop_dbus_properties_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = org_freedesktop_dbus_properties_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = org_freedesktop_dbus_properties_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = org_freedesktop_dbus_properties_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = org_freedesktop_dbus_properties_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (OrgFreedesktopDBusPropertiesSkeletonPrivate));
#endif
}

static void
org_freedesktop_dbus_properties_skeleton_iface_init (OrgFreedesktopDBusPropertiesIface *iface)
{
  iface->properties_changed = _org_freedesktop_dbus_properties_on_signal_properties_changed;
}

/**
 * org_freedesktop_dbus_properties_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>.
 *
 * Returns: (transfer full) (type OrgFreedesktopDBusPropertiesSkeleton): The skeleton object.
 */
OrgFreedesktopDBusProperties *
org_freedesktop_dbus_properties_skeleton_new (void)
{
  return ORG_FREEDESKTOP_DBUS_PROPERTIES (g_object_new (TYPE_ORG_FREEDESKTOP_DBUS_PROPERTIES_SKELETON, NULL));
}

