# Rofication

**Rofication** is a minimalistic notification system. It is loosely modeled after notification
centers on Android and Windows 10. The main idea is to not annoy (e.g. overlap parts of my
desktop) but still keep a persistent list of messages. Notifications are useful, however too many
notifications showing up too often (e.g. work mail popups) distract from the current task and are
therefore dismissed without proper reviewing. The goal is to show (in a single clear place) there
are notifications but not pop them up. It is up to the user to review the notifications when time
is available. If things are critical one should use a more direct media (e.g. face to face or phone). 

To summarize **Rofications**, it has:

 * 1 point to see if there are notifications. For example the status bar of your Desktop
   Environment.
![Notification Bar](https://raw.githubusercontent.com/DaveDavenport/Rofication/master/Picture/bar.png)
 * An application to (re)view all open notifications.
![Notification Bar](https://raw.githubusercontent.com/DaveDavenport/Rofication/master/Picture/client.png)
 * Persistent notifications, they stay around until dismissed. They should stick around, even over reboots.

# Techniques used

**Rofication** implements a notification daemon following the [Galago Desktop Notification
standard](http://www.galago-project.org/specs/notification/).  This is used by most Linux desktop
environments and most relevant applications support this. It is easily scriptable using
`notify-send`.  **Rofication** aims to be a drop-in replacement for existing notification daemons.

**Rofication** tries to re-use existing code as much as possible. It uses **Rofi** for displaying, 
i3blocks for the unintrusive notification and Python for `d-bus` implementation of notification
daemon.

# Structure
The main structure is like depicted below. The daemon acts as a storage point for the dbus messages
generated by the applications. The unix-socket interface allows clients to query the storage. A
proper protocol still has to be defined.


```
┌─────────────┐           ┌───────────────────┐                      ┌────────────────┐
│ application │ --dbus--> │ rofication-daemon │ <--- unix-socket --> │ rofication-gui │
└─────────────┘           └───────────────────┘       │              └────────────────┘
                                |                     │             ┌──────────────────────────┐
                                |                     \-----------> │ rofication-statusi3blocks│
                            <hdd:json-db>                           └──────────────────────────┘
```

The components consist of:

## Daemon

**Rofication** daemon is a small Python script that listens for notification messages on the local
dbus. Notifications are internally queued (and preserved) and can be viewed by a client via a
unix-socket. It is just a simple storage for notifications.

## Notification

**Rofication** does not implement its own 'widget' to display notifications. Instead it can be
easily integrated into existing tools.  Currently we ship a small script to integrate into
[`i3-blocks`](https://github.com/vivien/i3blocks). This shows the number of notifications and
signals when there are critical notifications. Ideally there should be several small scripts that
implement this for different desktop environments.

## GUI

The **Rofication** GUI consists of a small Python script wrapping **Rofi**. The GUI allows the user
to view notifications, mark them as seen and dismiss them.

## CLI

*This still needs to be written*
